/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;

public class ConcordanceFilterSelectionActionListener
implements ActionListener {
    private boolean isFilteringActive = false;
    private boolean isHapaxActive = false;
    private ConcordanceShellController controller;
    private JTable concordanceTable;
    private boolean selectAll;
    private boolean filterSelectedLines;

    public ConcordanceFilterSelectionActionListener(ConcordanceShellController controller) {
        this.controller = controller;
        this.concordanceTable = this.controller.getConcordanceTable();
        this.isHapaxActive = true;
    }

    public ConcordanceFilterSelectionActionListener(ConcordanceShellController controller, boolean selectAll, boolean isFilteringActive, boolean filterSelectedLines) {
        this.controller = controller;
        this.concordanceTable = this.controller.getConcordanceTable();
        this.selectAll = selectAll;
        this.filterSelectedLines = filterSelectedLines;
        this.isFilteringActive = isFilteringActive;
        this.isHapaxActive = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isFilteringActive) {
            Object[] object;
            CustomForegroundTableRenderer customForegroundTableRenderer;
            CustomForegroundTableRenderer customForegroundTableRenderer2;
            int k;
            Object annotations;
            Object color;
            DefaultTableModel backModel;
            int j;
            int i;
            DefaultTableModel model = (DefaultTableModel)this.concordanceTable.getModel();
            int[] selectedRows = this.concordanceTable.getSelectedRows();
            int selectedRowsLength = selectedRows.length;
            if (selectedRowsLength == 0) {
                return;
            }
            Arrays.sort(selectedRows);
            ArrayList<Object[]> listOfObjects = new ArrayList<Object[]>();
            if (this.filterSelectedLines) {
                block0: for (i = model.getRowCount() - 1; i > -1; --i) {
                    for (j = selectedRowsLength - 1; j > -1; --j) {
                        if (i == selectedRows[j]) {
                            backModel = this.controller.getTableModel();
                            if (backModel != null) {
                                color = model.getValueAt(i, 4);
                                annotations = model.getValueAt(i, 5);
                                for (k = backModel.getRowCount() - 1; k > -1; --k) {
                                    if (!color.equals(backModel.getValueAt(k, 4)) || !annotations.equals(backModel.getValueAt(k, 5))) continue;
                                    backModel.removeRow(k);
                                    customForegroundTableRenderer2 = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                                    customForegroundTableRenderer2.updateMapsWhenRowIsDeleted(i, k);
                                    continue block0;
                                }
                                continue block0;
                            }
                            customForegroundTableRenderer = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                            customForegroundTableRenderer.updateMapsWhenRowIsDeleted(-1, i);
                            continue block0;
                        }
                        if (j != 0) continue;
                        object = new Object[]{model.getValueAt(i, 0), model.getValueAt(i, 1), model.getValueAt(i, 2), model.getValueAt(i, 3), model.getValueAt(i, 4), model.getValueAt(i, 5)};
                        listOfObjects.add(object);
                    }
                }
            } else {
                block3: for (i = model.getRowCount() - 1; i > -1; --i) {
                    block4: for (j = selectedRowsLength - 1; j > -1; --j) {
                        if (i == selectedRows[j]) {
                            object = new Object[]{model.getValueAt(i, 0), model.getValueAt(i, 1), model.getValueAt(i, 2), model.getValueAt(i, 3), model.getValueAt(i, 4), model.getValueAt(i, 5)};
                            listOfObjects.add(object);
                            continue block3;
                        }
                        if (j != 0) continue;
                        backModel = this.controller.getTableModel();
                        if (backModel != null) {
                            color = model.getValueAt(i, 4);
                            annotations = model.getValueAt(i, 5);
                            for (k = backModel.getRowCount() - 1; k > -1; --k) {
                                if (!color.equals(backModel.getValueAt(k, 4)) || !annotations.equals(backModel.getValueAt(k, 5))) continue;
                                backModel.removeRow(k);
                                customForegroundTableRenderer2 = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                                customForegroundTableRenderer2.updateMapsWhenRowIsDeleted(i, k);
                                continue block4;
                            }
                            continue;
                        }
                        customForegroundTableRenderer = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                        customForegroundTableRenderer.updateMapsWhenRowIsDeleted(-1, i);
                    }
                }
            }
            model.getDataVector().removeAllElements();
            model.fireTableDataChanged();
            Collections.reverse(listOfObjects);
            for (int k2 = 0; k2 < listOfObjects.size(); ++k2) {
                model.addRow((Object[])listOfObjects.get(k2));
            }
            this.concordanceTable.setModel(model);
            this.filterHelpFunction(this.controller, model);
            return;
        }
        if (!this.isHapaxActive) {
            if (this.selectAll) {
                this.concordanceTable.setRowSelectionInterval(0, this.concordanceTable.getRowCount() - 1);
            } else {
                this.concordanceTable.getSelectionModel().clearSelection();
            }
        } else {
            DefaultTableModel model = (DefaultTableModel)this.concordanceTable.getModel();
            for (int i = model.getRowCount() - 1; i > -1; --i) {
                if (!this.onlyOne(model, i)) continue;
                DefaultTableModel backModel = this.controller.getTableModel();
                if (backModel != null) {
                    Object color = model.getValueAt(i, 4);
                    Object annotations = model.getValueAt(i, 5);
                    for (int k = backModel.getRowCount() - 1; k > -1; --k) {
                        if (!color.equals(backModel.getValueAt(k, 4)) || !annotations.equals(backModel.getValueAt(k, 5))) continue;
                        backModel.removeRow(k);
                        CustomForegroundTableRenderer customForegroundTableRenderer = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                        customForegroundTableRenderer.updateMapsWhenRowIsDeleted(i, k);
                        break;
                    }
                } else {
                    CustomForegroundTableRenderer customForegroundTableRenderer = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                    customForegroundTableRenderer.updateMapsWhenRowIsDeleted(-1, i);
                }
                model.removeRow(i);
                this.concordanceTable.getSelectionModel().clearSelection();
            }
            this.filterHelpFunction(this.controller, model);
        }
    }

    private void filterHelpFunction(ConcordanceShellController controller, DefaultTableModel model) {
        List<Object> theItems = controller.getTheItems();
        for (int j = 0; j < theItems.size(); j += 4) {
            theItems.set(j + 2, false);
        }
        block1: for (int k = 0; k < model.getRowCount(); ++k) {
            for (int l = 0; l < theItems.size(); l += 4) {
                Object[] item = (Object[])theItems.get(l + 1);
                if (!item[5].equals(model.getValueAt(k, 5))) continue;
                theItems.set(l + 2, true);
                continue block1;
            }
        }
        controller.setTheItems(theItems);
        if (controller.getSyntacticTreeShell() != null) {
            controller.getSyntacticTreeShell().dispose();
            controller.setSyntacticTreeShell(null);
        }
        controller.getConcordanceShell().getEntriesNBLabel().setText(model.getRowCount() + "/" + theItems.size() / 4);
    }

    private boolean onlyOne(DefaultTableModel model, int index) {
        String seq = model.getValueAt(index, 2).toString();
        for (int i = model.getRowCount() - 1; i > -1; --i) {
            String seqc;
            if (model.getValueAt(index, 0).equals(model.getValueAt(i, 0)) && model.getValueAt(index, 1).equals(model.getValueAt(i, 1)) && model.getValueAt(index, 2).equals(model.getValueAt(i, 2)) && model.getValueAt(index, 3).equals(model.getValueAt(i, 3)) && model.getValueAt(index, 4).equals(model.getValueAt(i, 4)) && model.getValueAt(index, 5).equals(model.getValueAt(i, 5)) || !seq.equals(seqc = model.getValueAt(i, 2).toString())) continue;
            return false;
        }
        return true;
    }
}

